<?php
$_['opencart_version'] = array(
    "2.0.0.0",
    "2.0.1.0",
    "2.0.1.1",
    "2.0.2.0",
    "2.0.3.1",
    "2.1.0.1",
    "2.1.0.2",
    "2.2.0.0",
    "2.3.0.0",
    "2.3.0.1",
    "2.3.0.2");
$_['main_sheet'] = array(
    'name' => 'Products',
    'table' =>  array(
        'name' => 'p',
        'full_name' => 'product',
        'key' => 'product_id'
        ),
    'tables' => array(
        array(
            'name' => 'pd',
            'full_name' => 'product_description',
            'key' => 'product_id',
            'join' => 'INNER',
            'multi_language' => 1
            ),
        array(
            'name' => 'p2c',
            'full_name' => 'product_to_category',
            'join' => 'LEFT',
            'key' => 'product_id',
            'concat' => 1
            ),
        array(
            'name' => 'p2s',
            'full_name' => 'product_to_store',
            'join' => 'LEFT',
            'key' => 'product_id',
            'concat' => 1
            ),
        array(
            'name' => 'p2d',
            'full_name' => 'product_to_download',
            'join' => 'LEFT',
            'key' => 'product_id',
            'concat' => 1
            ),
        array(
            'name' => 'pf',
            'full_name' => 'product_filter',
            'join' => 'LEFT',
            'key' => 'product_id',
            'concat' => 1
            ),
        array(
            'name' => 'pr',
            'full_name' => 'product_related',
            'join' => 'LEFT',
            'key' => 'product_id',
            'concat' => 1
            ),
        array(
            'name' => 'ua',
            'full_name' => 'url_alias',
            'key' => 'query',
            'related_key' => 'query',
            'prefix' => 'product_id=',
            'clear' => 1,
            'not_empty' => 1,
            'join' => 'LEFT'
            )
        ),
    'columns' => array(
        array(
            'column' => 'product_id',
            'table' => 'p',
            'name' => 'Product ID',
            'filter' => 1
            ),
        array(
            'column' => 'name',
            'table' => 'pd',
            'name' => 'Name',
            'filter' => 1
            ),
        array(
            'column' => 'model',
            'table' => 'p',
            'name' => 'Model',
            'filter' => 1
            ),
        array(
            'column' => 'sku',
            'table' => 'p',
            'name' => 'SKU',
            'filter' => 1
            ),
        array(
            'column' => 'description',
            'table' => 'pd',
            'name' => 'Description',
            'filter' => 1
            ),
        array(
            'column' => 'meta_title',
            'table' => 'pd',
            'name' => 'Meta Title',
            'filter' => 1
            ),
        array(
            'column' => 'meta_keyword',
            'table' => 'pd',
            'name' => 'Meta Keyword',
            'filter' => 1
        ),
        array(
            'column' => 'meta_description',
            'table' => 'pd',
            'name' => 'Meta Description',
            'filter' => 1
        ),
        array(
            'column' => 'tag',
            'table' => 'pd',
            'name' => 'Tags',
            'filter' => 1
            ),
        array(
            'column' => 'upc',
            'table' => 'p',
            'name' => 'UPC',
            'filter' => 1
            ),
        array(
            'column' => 'ean',
            'table' => 'p',
            'name' => 'EAN',
            'filter' => 1
            ),
        array(
            'column' => 'jan',
            'table' => 'p',
            'name' => 'JAN',
            'filter' => 1
            ),
        array(
            'column' => 'isbn',
            'table' => 'p',
            'name' => 'ISBN',
            'filter' => 1
            ),
        array(
            'column' => 'mpn',
            'table' => 'p',
            'name' => 'MPN',
            'filter' => 1
            ),
        array(
            'column' => 'price',
            'table' => 'p',
            'name' => 'Price',
            'filter' => 1
            ),
        array(
            'column' => 'location',
            'table' => 'p',
            'name' => 'Location'
            ),
        array(
            'column' => 'status',
            'table' => 'p',
            'name' => 'Status',
            'filter' => 1
            ),
        array(
            'column' => 'tax_class_id',
            'table' => 'p',
            'name' => 'Tax Class Id'
            ),
        array(
            'column' => 'quantity',
            'table' => 'p',
            'name' => 'Quantity',
            'filter' => 1
            ),
        array(
            'column' => 'minimum',
            'table' => 'p',
            'name' => 'Minimum Quantity',
            'filter' => 1
            ),
        array(
            'column' => 'image',
            'table' => 'p',
            'name' => 'Image',
            'filter' => 1
            ),
        array(
            'column' => 'subtract',
            'table' => 'p',
            'name' => 'Subtrack Stock',
            'filter' => 1
            ),
        array(
            'column' => 'stock_status_id',
            'table' => 'p',
            'name' => 'Out Of Stock Status',
            'filter' => 1
            ),
        array(
            'column' => 'shipping',
            'table' => 'p',
            'name' => 'Requires Shipping'
            ),
        array(
            'column' => 'date_available',
            'table' => 'p',
            'name' => 'Date Available'
            ),
        array(
            'column' => 'viewed',
            'table' => 'p',
            'name' => 'Viewed'
            ),
        array(
            'column' => 'length',
            'table' => 'p',
            'name' => 'Length'
            ),
        array(
            'column' => 'width',
            'table' => 'p',
            'name' => 'Width'
            ),
        array(
            'column' => 'height',
            'table' => 'p',
            'name' => 'Height'
            ),
        array(
            'column' => 'length_class_id',
            'table' => 'p',
            'name' => 'Length Class ID'
            ),
        array(
            'column' => 'weight',
            'table' => 'p',
            'name' => 'Weight'
            ),
        array(
            'column' => 'weight_class_id',
            'table' => 'p',
            'name' => 'Weight Class ID'
            ),
        array(
            'column' => 'points',
            'table' => 'p',
            'name' => 'Points',
            'filter' => 1
            ),
        array(
            'column' => 'keyword',
            'table' => 'ua',
            'name' => 'SEO Keyword'
            ),
        array(
            'column' => 'manufacturer_id',
            'table' => 'p',
            'name' => 'Manufacturer ID',
            'filter' => 1
            ),
        array(
            'column' => 'category_id',
            'table' => 'p2c',
            'concat' => 1,
            'name' => 'Categories',
            'filter' => 1
            ),
        array(
            'column' => 'filter_id',
            'table' => 'pf',
            'concat' => 1,
            'name' => 'Filters',
            'filter' => 1
            ),
        array(
            'column' => 'store_id',
            'table' => 'p2s',
            'concat' => 1,
            'name' => 'Stores',
            'filter' => 1
            ),
        array(
            'column' => 'download_id',
            'table' => 'p2d',
            'concat' => 1,
            'name' => 'Downloads',
            'filter' => 1
            ),
        array(
            'column' => 'related_id',
            'table' => 'pr',
            'concat' => 1,
            'name' => 'Related Products',
            'filter' => 1
            )
        )
);

$_['sheets'] = array(
    array(
        'name' => 'Attributes',
        'table' => array(
            'name' => 'pa',
            'full_name' => 'product_attribute',
            'related_key' => 'product_id',
            'key' => array('product_id', 'attribute_id', 'language_id'),
            'multi_language' => 1
            ),
        'tables' => array(),
        'columns' => array(
            array(
                'column' => 'product_id',
                'table' => 'pa',
                'name' => 'Product ID'
                ),
            array(
                'column' => 'attribute_id',
                'table' => 'pa',
                'name' => 'Attribute ID'
                ),
            array(
                'column' => 'text',
                'table' => 'pa',
                'name' => 'Text'
                )
            )
        ),
    array(
        'name' => 'Options',

        'table' => array(
            'name' => 'po',
            'full_name' => 'product_option',
            'key' => 'product_option_id',
            'related_key' => 'product_id'
            ),

        'tables' => array(),
        
        'columns' => array(
            array(
                'column' => 'product_id',
                'table' => 'po',
                'name' => 'Product ID'
                ),
            array(
                'column' => 'product_option_id',
                'table' => 'po',
                'name' => 'Product Option ID'
                ),
            array(
                'column' => 'option_id',
                'table' => 'po',
                'name' => 'Option ID'
                ),
            array(
                'column' => 'value',
                'table' => 'po',
                'name' => 'Default Option Value'
                ),
            array(
                'column' => 'required',
                'table' => 'po',
                'name' => 'Required'
                )
            ),
        'values' => array(
            'table' => array(
                'name' => 'pov',
                'full_name' => 'product_option_value',
                'related_key' => 'product_option_id',
                'require_key' => 'option_id',
                'key' => 'product_option_value_id'
                ),
            'tables' => array(),
            'columns' => array(
                array(
                    'column' => 'option_value_id',
                    'table' => 'pov',
                    'name' => 'Option Value ID'
                    ),
                array(
                    'column' => 'quantity',
                    'table' => 'pov',
                    'name' => 'Quantity'
                    ),
                array(
                    'column' => 'subtract',
                    'table' => 'pov',
                    'name' => 'Subtrack Stock'
                    ),
                array(
                    'column' => 'price_prefix',
                    'table' => 'pov',
                    'name' => 'Price Prefix'
                    ),
                array(
                    'column' => 'price',
                    'table' => 'pov',
                    'name' => 'Price'
                    ),
                array(
                    'column' => 'points_prefix',
                    'table' => 'pov',
                    'name' => 'Points Prefix'
                    ),
                array(
                    'column' => 'points',
                    'table' => 'pov',
                    'name' => 'Points'
                    ),
                array(
                    'column' => 'weight_prefix',
                    'table' => 'pov',
                    'name' => 'Weight Prefix'
                    ),
                array(
                    'column' => 'weight',
                    'table' => 'pov',
                    'name' => 'Weight'
                    ),
                )
            )
        ),
    array(
        'name' => 'Recurring',
        'table' => array(
            'name' => 'pr',
            'full_name' => 'product_recurring',
            'related_key' => 'product_id',
            'key' => array('product_id', 'recurring_id', 'customer_group_id')
            ),
        'tables' => array(),
        'columns' => array(
            array(
                'column' => 'product_id',
                'table' => 'pr',
                'name' => 'Product ID'
                ),
            array(
                'column' => 'recurring_id',
                'table' => 'pr',
                'name' => 'Recurring ID'
                ),
            array(
                'column' => 'customer_group_id',
                'table' => 'pr',
                'name' => 'Customer Group ID'
                ),
            )
        ),
    array(
        'name' => 'Discount',
        'table' => array(
            'name' => 'pd',
            'full_name' => 'product_discount',
            'related_key' => 'product_id',
            'key' => 'product_discount_id'
            ),
        'tables' => array(),
        'columns' => array(
            array(
                'column' => 'product_id',
                'table' => 'pd',
                'name' => 'Product ID'
                ),
            array(
                'column' => 'customer_group_id',
                'table' => 'pd',
                'name' => 'Customer Group ID'
                ),
            array(
                'column' => 'quantity',
                'table' => 'pd',
                'name' => 'Quantity'
                ),
            array(
                'column' => 'priority',
                'table' => 'pd',
                'name' => 'Priority'
                ),
            array(
                'column' => 'price',
                'table' => 'pd',
                'name' => 'Price'
                ),
            array(
                'column' => 'date_start',
                'table' => 'pd',
                'name' => 'Date Start'
                ),
            array(
                'column' => 'date_end',
                'table' => 'pd',
                'name' => 'Date End'
                ),
            )
        ),
    array(
        'name' => 'Special',
        'table' => array(
            'name' => 'ps',
            'full_name' => 'product_special',
            'related_key' => 'product_id',
            'key' => 'product_special_id'
            ),
        'tables' => array(),
        'columns' => array(
            array(
                'column' => 'product_id',
                'table' => 'ps',
                'name' => 'Product ID'
                ),
            array(
                'column' => 'customer_group_id',
                'table' => 'ps',
                'name' => 'Customer Group ID'
                ),
            array(
                'column' => 'priority',
                'table' => 'ps',
                'name' => 'Priority'
                ),
            array(
                'column' => 'price',
                'table' => 'ps',
                'name' => 'Price'
                ),
            array(
                'column' => 'date_start',
                'table' => 'ps',
                'name' => 'Date Start'
                ),
            array(
                'column' => 'date_end',
                'table' => 'ps',
                'name' => 'Date End'
                ),
            )
        ),
    array(
        'name' => 'Image',
        'table' => array(
            'name' => 'pi',
            'full_name' => 'product_image',
            'related_key' => 'product_id',
            'key' => 'product_image_id'
            ),
        'tables' => array(),
        'columns' => array(
            array(
                'column' => 'product_id',
                'table' => 'pi',
                'name' => 'Product ID'
                ),
            array(
                'column' => 'image',
                'table' => 'pi',
                'name' => 'Image'
                ),
            array(
                'column' => 'sort_order',
                'table' => 'pi',
                'name' => 'Sort Order'
                ),
            )
        ),
    array(
        'name' => 'Reward Points',
        'table' => array(
            'name' => 'pr',
            'full_name' => 'product_reward',
            'related_key' => 'product_id',
            'key' => 'product_reward_id'
            ),
        'tables' => array(),
        'columns' => array(
            array(
                'column' => 'product_id',
                'table' => 'pr',
                'name' => 'Product ID'
                ),
            array(
                'column' => 'customer_group_id',
                'table' => 'pr',
                'name' => 'Customer Group ID'
                ),
            array(
                'column' => 'points',
                'table' => 'pr',
                'name' => 'Points'
                ),
            )
        ),
    array(
        'name' => 'Design',
        'table' => array(
            'name' => 'pl',
            'full_name' => 'product_to_layout',
            'related_key' => 'product_id',
            'key' => array('product_id', 'store_id')
            ),
        'tables' => array(),
        'columns' => array(
            array(
                'column' => 'product_id',
                'table' => 'pl',
                'name' => 'Product ID'
                ),
            array(
                'column' => 'store_id',
                'table' => 'pl',
                'name' => 'Store ID'
                ),
            array(
                'column' => 'layout_id',
                'table' => 'pl',
                'name' => 'Layout ID'
                ),
            )
        ),
    );
