<?php
$_['main_sheet'] = array(
    'name' => 'Coupons',
    'table' => array(
        'name' => 'c',
        'full_name' => 'coupon',
        'key' => 'coupon_id'
        ),

    'tables' => array(
        array(
            'name' => 'cp',
            'full_name' => 'coupon_product',
            'join' => 'LEFT',
            'key' => 'coupon_id',
            'concat' => 1
        ),
        array(
            'name' => 'cc',
            'full_name' => 'coupon_category',
            'join' => 'LEFT',
            'key' => 'coupon_id',
            'concat' => 1
        )
    ),

    'columns' => array(
        array(
            'column' => 'coupon_id',
            'table' => 'c',
            'name' => 'Coupon ID',
            'filter' => 1
            ),
        array(
            'column' => 'name',
            'table' => 'c',
            'name' => 'Coupon Name',
            'filter' => 1
            ),
        array(
            'column' => 'code',
            'table' => 'c',
            'name' => 'Code',
            'filter' => 1
            ),
        array(
            'column' => 'type',
            'table' => 'c',
            'name' => 'Type',
            'filter' => 1
            ),
        array(
            'column' => 'discount',
            'table' => 'c',
            'name' => 'Discount'
            ),
        array(
            'column' => 'Logged',
            'table' => 'c',
            'name' => 'Customer Login',
            'filter' => 1
            ),
        array(
            'column' => 'shipping',
            'table' => 'c',
            'name' => 'Free Shipping',
            'filter' => 1
            ),
        array(
            'column' => 'product_id',
            'table' => 'cp',
            'name' => 'Products',
            'concat' => 1
            ),
        array(
            'column' => 'category_id',
            'table' => 'cc',
            'name' => 'Category',
            'concat' => 1
            ),
        array(
            'column' => 'total',
            'table' => 'c',
            'name' => 'Total Amount'
            ),
        array(
            'column' => 'date_start',
            'table' => 'c',
            'name' => 'Date Start'
            ),
        array(
            'column' => 'date_end',
            'table' => 'c',
            'name' => 'Date End'
            ),
        array(
            'column' => 'uses_total',
            'table' => 'c',
            'name' => 'Uses Per Coupon'
            ),
        array(
            'column' => 'uses_customer',
            'table' => 'c',
            'name' => 'Uses Per Customer'
            ),
        array(
            'column' => 'status',
            'table' => 'c',
            'name' => 'Status'
            ),
        array(
            'column' => 'date_added',
            'table' => 'c',
            'name' => 'Date Added'
            )
        )
    );

$_['sheets'] = array(
    array(
        'name' => 'History',
        'table' => array(
            'name' => 'ch',
            'full_name' => 'coupon_history',
            'related_key' => 'coupon_id',
            'key' => 'coupon_history_id'
            ),
        'tables' => array(),
        'columns' => array(
            array(
                'column' => 'coupon_id',
                'table' => 'ch',
                'name' => 'Coupon ID'
                ),
            array(
                'column' => 'order_id',
                'table' => 'ch',
                'name' => 'Order ID'
                ),
            array(
                'column' => 'customer_id',
                'table' => 'ch',
                'name' => 'Customer ID'
                ),
            array(
                'column' => 'amount',
                'table' => 'ch',
                'name' => 'Amount'
                ),
            array(
                'column' => 'date_added',
                'table' => 'ch',
                'name' => 'Date Added'
                )
            )
        )
    );
