<?php
//==============================================================================
// Stripe Payment Gateway Pro (v3 installer)
// 
// Author: Clear Thinking, LLC
// E-mail: johnathan@getclearthinking.com
// Website: http://www.getclearthinking.com
// 
// All code within this file is copyright Clear Thinking, LLC.
// You may not copy or reuse code within this file without written permission.
//==============================================================================

class ControllerExtensionPaymentStripe extends Controller {
	private $type = 'payment';
	private $name = 'stripe';
	
	public function index() {
		// Load extension data
		$data = $this->loadLanguage($this->type . '/' . $this->name);
		
		$data['type'] = $this->type;
		$data['name'] = $this->name;
		$data['token'] = $this->session->data[version_compare(VERSION, '3.0', '<') ? 'token' : 'user_token'];
		$data['exit'] = $this->url->link((version_compare(VERSION, '3.0', '<') ? 'extension' : 'marketplace') . '/' . (version_compare(VERSION, '2.3', '<') ? '' : 'extension&type=') . $this->type . '&token=' . $data['token'], '', 'SSL');
		
		// Render
		$this->document->setTitle($data['heading_title']);
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		if (version_compare(VERSION, '4.0', '<')) {
			$template_file = DIR_TEMPLATE . 'extension/' . $this->type . '/' . $this->name . '.twig';
		} elseif (defined('DIR_EXTENSION')) {
			$template_file = DIR_EXTENSION . $this->name . '/admin/view/template/' . $this->type . '/' . $this->name . '.twig';
		}
		
		if (is_file($template_file)) {
			extract($data);
			
			ob_start();
			if (version_compare(VERSION, '4.0', '<')) {
				require(class_exists('VQMod') ? \VQMod::modCheck(modification($template_file)) : modification($template_file));
			} else {
				require(class_exists('VQMod') ? \VQMod::modCheck($template_file) : $template_file);
			}
			$output = ob_get_clean();
			
			if (version_compare(VERSION, '3.0', '>=')) {
				$output = str_replace(array('&token=', '&amp;token='), '&user_token=', $output);
			}
			
			if (version_compare(VERSION, '4.0', '>=')) {
				$separator = (version_compare(VERSION, '4.0.2.0', '<')) ? '|' : '.';
				$output = str_replace($data['extension_route'] . '/', $data['extension_route'] . $separator, $output);
			}
			
			echo $output;
		} else {
			echo 'Error loading template file: ' . $template_file;
		}
	}
	
	//==============================================================================
	// Helper functions
	//==============================================================================
	private function hasPermission($permission) {
		if (version_compare(VERSION, '2.3', '<')) {
			return $this->user->hasPermission($permission, $this->type . '/' . $this->name);
		} elseif (version_compare(VERSION, '4.0', '<')) {
			return $this->user->hasPermission($permission, 'extension/' . $this->type . '/' . $this->name);
		} else {
			return $this->user->hasPermission($permission, 'extension/' . $this->name . '/' . $this->type . '/' . $this->name);
		}
	}
	
	private function loadLanguage($path) {
		$_ = array();
		$language = array();
		if (version_compare(VERSION, '2.2', '<')) {
			$admin_language = $this->db->query("SELECT * FROM " . DB_PREFIX . "language WHERE `code` = '" . $this->db->escape($this->config->get('config_admin_language')) . "'")->row['directory'];
		} elseif (version_compare(VERSION, '4.0', '<')) {
			$admin_language = $this->config->get('config_admin_language');
		} else {
			$admin_language = $this->config->get('config_language_admin');
		}
		foreach (array('english', 'en-gb', $admin_language) as $directory) {
			$file = DIR_LANGUAGE . $directory . '/' . $directory . '.php';
			if (file_exists($file)) require(class_exists('VQMod') ? \VQMod::modCheck($file) : $file);
			$file = DIR_LANGUAGE . $directory . '/default.php';
			if (file_exists($file)) require(class_exists('VQMod') ? \VQMod::modCheck($file) : $file);
			$file = DIR_LANGUAGE . $directory . '/' . $path . '.php';
			if (file_exists($file)) require(class_exists('VQMod') ? \VQMod::modCheck($file) : $file);
			$file = DIR_LANGUAGE . $directory . '/extension/' . $path . '.php';
			if (file_exists($file)) require(class_exists('VQMod') ? \VQMod::modCheck($file) : $file);
			if (defined('DIR_EXTENSION')) {
				$file = DIR_EXTENSION . 'opencart/admin/language/' . $directory . '/' . $path . '.php';
				if (file_exists($file)) require(class_exists('VQMod') ? \VQMod::modCheck($file) : $file);
				$explode = explode('/', $path);
				$file = DIR_EXTENSION . $explode[1] . '/admin/language/' . $directory . '/' . $path . '.php';
				if (file_exists($file)) require(class_exists('VQMod') ? \VQMod::modCheck($file) : $file);
				$file = DIR_EXTENSION . $this->name . '/admin/language/' . $directory . '/' . $path . '.php';
				if (file_exists($file)) require(class_exists('VQMod') ? \VQMod::modCheck($file) : $file);
			}
			$language = array_merge($language, $_);
		}
		return $language;
	}
	
	private function curlRequest($url, $data) {
		$curl = curl_init($url);
		
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
		
		curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 30);
		curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
		curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
		curl_setopt($curl, CURLOPT_HEADER, false);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_TIMEOUT, 30);
		
		$response = curl_exec($curl);
		curl_close($curl);
		
		return $response;
	}
	
	//==============================================================================
	// verify()
	//==============================================================================
	public function verify() {
		$language = $this->loadLanguage($this->type . '/' . $this->name);
		
		if (!$this->hasPermission('modify')) {
			echo $language['standard_error'];
			return;
		}
		
		if (empty($this->request->post['key'])) {
			echo $language['error_blank'];
			return;
		}
		
		// get zip data
		$this->request->post['extension'] = $language['heading_title'];
		$this->request->post['version'] = VERSION;
		$this->request->post['domain'] = HTTP_CATALOG;
		$this->request->post['ip'] = $this->request->server['REMOTE_ADDR'];
		
		$zip_file = $this->curlRequest('https://www.getclearthinking.com/downloads/install', $this->request->post);
		
		if (strpos($zip_file, '<i class="fa') === 0) {
			echo $zip_file;
			return;
		}
		
		$temp_zip = DIR_DOWNLOAD . 'clearthinking.zip';
		$file = fopen($temp_zip, 'w+');
		fwrite($file, $zip_file);
		fclose($file);
		
		// unzip bundle
		$temp_directory = DIR_DOWNLOAD . 'clearthinking/';
		$zip = new ZipArchive();

		if ($zip->open($temp_zip)) {
			$zip->extractTo($temp_directory);
			$zip->close();
		} else {
			echo 'Zip archive failed to unzip';
			return;
		}
		
		@unlink($temp_zip);
		
		// unzip secondary bundle
		if (version_compare(VERSION, '2.0', '<')) {
			$secondary_zip = $temp_directory . 'OpenCart 1.5 Versions.zip';
		} elseif (version_compare(VERSION, '2.3', '<')) {
			$secondary_zip = $temp_directory . 'OpenCart 2.0-2.2 Versions.ocmod.zip';
		} else {
			$secondary_zip = $temp_directory . 'OpenCart 2.3-3.0 Versions.ocmod.zip';
		}
		
		$zip = new ZipArchive();

		if ($zip->open($secondary_zip)) {
			$admin_directory = basename(DIR_APPLICATION);
			
			for ($i = 0; $i < $zip->numFiles; $i++) {
				$filepath = str_replace(array('upload/', 'admin/'), array('', $admin_directory . '/'), $zip->getNameIndex($i));
				
				if (strpos($filepath, '.txt')) {
					continue;
				}
				
				if ($filepath === 'install.xml') {
					$xml = $zip->getFromIndex($i);
					
					foreach (array('name', 'code', 'version', 'author', 'link') as $tag) {
						$first_explosion = explode('<' . $tag . '>', $xml);
						$second_explosion = explode('</' . $tag . '>', $first_explosion[1]);
						${'xml_'.$tag} = $second_explosion[0];
					}
					
					$this->db->query("DELETE FROM " . DB_PREFIX . "modification WHERE code = '" . $this->db->escape($xml_code) . "'");
					
					$this->db->query("INSERT INTO " . DB_PREFIX . "modification SET code = '" . $this->db->escape($xml_code) . "', name = '" . $this->db->escape($xml_name) . "', author = '" . $this->db->escape($xml_author) . "', version = '" . $this->db->escape($xml_version) . "', link = '" . $this->db->escape($xml_link) . "', xml = '" . $this->db->escape($xml) . "', status = 1, date_added = NOW()");
					
					continue;
				}
				
				$full_filepath = DIR_APPLICATION . '../' . $filepath;
				
				if (!strpos($filepath, '.')) {
					if (!is_dir($full_filepath)) {
						mkdir($full_filepath, 0777);
					}
					continue;
				}
				
				file_put_contents($full_filepath, $zip->getFromIndex($i));
			}
			
			$zip->close();
		} else {
			echo 'Zip archive failed to unzip';
			return;
		}
		
		// get rid of unnecessary files
		@array_map('unlink', array_filter((array)glob($temp_directory . '*')));
		@rmdir($temp_directory);
		
		// finish
		echo 'success';
	}
	
}
?>